import { BoardMemberDetail } from "../types/boardDetail";

export default function BoardDetail({ member }: { member: BoardMemberDetail }) {
  const fullName = member.fullName || "";
  const position = member.position || "";
  const content = member.content || "";
  const picture = member.picture || "";
  const workHistories = member.workHistories || [];

  return (
    <div className="managersDetailPages">
      <div className="mainSmall">
        {/* بخش بالای صفحه */}
        <section className="managersDetailPages_top flex flexSpace alignStart">
          <div className="managersDetailPages_top_r">
            <div className="drTitle">
              <h2 className="blueTxt">{fullName}</h2>
              <span>{position}</span>
            </div>
            <div className="desc">
              <p>{content}</p>
            </div>
          </div>

          <div className="managersDetailPages_top_l">
            <div className="drImg relative">
              <figure className="relative radius48 w100 h100 overflow">
                <img
                  src={picture}
                  alt={fullName}
                  className="w100 h100 objectfitCover"
                />
              </figure>
            </div>
          </div>
        </section>

        {/* سوابق */}
        <section className="managersDetailPages_bottom">
          <div className="publicTitle">
            <div className="topTitle flex flexDirColumn alignCenter">
              <strong>
                <span>سوابق کاری</span>
                <label>{fullName}</label>
              </strong>
            </div>
          </div>

          <div className="recordsDrList">
            <ul>
              {workHistories.map((rec, i) => (
                <li key={i}>
                  <div className="recordsDrList_item HospitalDepartmentsInfo_slider_item radius16 boxShadow relative">
                    <div className="recordsDrList_item_Title HospitalDepartmentsInfoTitle txtCenter">
                      <span>{rec.title}</span>
                    </div>
                    <div className="desc">
                      <p>{rec.description}</p>
                    </div>
                  </div>
                </li>
              ))}
            </ul>
          </div>
        </section>
      </div>
    </div>
  );
}
