
import type { BoardMembersItem } from "../types/boardMembers";

type Props = { member: BoardMembersItem };

export default function BoardItem({ member }: Props) {
  return (
    <div className="boardDirectors_list_item relative">
      <div className="boardDirectors_list_item_img relative">
        <figure className="radius50 w100 h100 overflow">
          <img src={member.picture} alt={member.fullName} className="w100 h100 objectfitCover" />
        </figure>
      </div>
      <div className="boardDirectors_list_item_desc">
        <h2>{member.fullName}</h2>
        <span>{member.position}</span>
      </div>
      <div className="allview w100">
        <span className="radius40 greenBg whiteTxt flex flexCenter alignCenter w100 h100 transition animationGreenBox">
          مشاهده
        </span>
      </div>
    </div>
  );
}
