import Link from "next/link";
import BoardItem from "./BoardItem";
import type { BoardMembersItem } from "../types/boardMembers";

export default function BoardList({ members }: { members: BoardMembersItem[] })  {
  return (
    <ul className="boardDirectors_grid">
      {members.map((m) => (
        <li key={m.slug}>
          <Link href={`/about/board/${m.slug}`}>
            <BoardItem member={m} />
          </Link>
        </li>
      ))}
    </ul>
  );
}
