import { getBoardMembersPage } from "@/src/lib/boardApi";
import TitlePage from "@/app/components/common/TitlePage"; 
import BoardList from "./components/BoardList";
import { notFound } from "next/navigation";

export async function generateMetadata() {
  const data = await getBoardMembersPage();
  if (!data) return notFound();

  const p = data.pageInfo;

  return {
    title: p.pageTitle || p.title,
    description: p.pageDescription || p.ogDescription || "",
    alternates: {
      canonical: p.canonical || "/about/board",
    },
    openGraph: {
      title: p.ogTitle || p.title,
      description: p.ogDescription || "",
      images: p.ogImage ? [{ url: p.ogImage }] : [],
      url: p.canonical,
    },
    robots: p.pageRobotsStatus || undefined,
  };
}

export default async function Page() {
  const data = await getBoardMembersPage();
  if (!data) return notFound();

  return (
    <div className="boardDirectorsPage">
      <div className="mainSmall">

        {/*pageInfo*/}
        <TitlePage title={data.pageInfo.title} />

        <section className="boardDirectors_list">
          {/*Member List*/}
          <BoardList members={data.boardMembers} />
        </section>

      </div>
    </div>
  );
}
