
import type { HistorySection } from "@/src/types/about";

type AboutHistoryProps = {
  historySection: HistorySection;
};

export default function AboutHistory({ historySection }: AboutHistoryProps) {
  return (
    <section className="aboutPageHistory">
      <div className="mainSmall">
        {/*Main title*/}
        <div className="publicTitle">
          <div className="topTitle flex flexDirColumn alignCenter w100">
  <strong dangerouslySetInnerHTML={{ __html: historySection.title }} />
  <p>{historySection.description}</p>
</div>
        </div>

        {/*History List*/}
        <div className="historyList relative">
          <ul>
            {historySection.items.map((item, index) => (
              <li key={index}>
                <div className="historyList_item flex flexSpace alignStart">
                  {/* description */}
                  <div className="historyList_item_desc">
                    <div className="publicTitle">
                      <div className="topTitle">
                        <strong>
                          <span>{item.title}</span>
                          <label>بیمارستان رضوی</label>
                        </strong>
                      </div>
                    </div>
                    <div className="desc">
                      <p>{item.description}</p>
                    </div>
                  </div>

                  {/* number + year */}
                  <div className="historyList_item_yearNum">
                    <div className="year radius12 flex flexCenter alignCenter relative">
                      <span>{item.year}</span>
                    </div>
                    <div className="numItem">
                      <label>
                        {String(index + 1).padStart(2, "0")}
                      </label>
                    </div>
                  </div>
                </div>
              </li>
            ))}
          </ul>
        </div>
      </div>
    </section>
  );
}