import Image from "next/image";
import type { PageInfo } from "@/src/types/about";

type AboutIntroProps = {
  pageInfo?: PageInfo;
};

export default function AboutIntro({ pageInfo }: AboutIntroProps) {
  if (!pageInfo) {
    return null; 
  }

  const { picture, title, content } = pageInfo;

  const imageSrc = picture || "/images/fallback.jpg";

  return (
    <section className="aboutPageCms mainSmall">
      <div className="aboutPageCms_img relative radius20">
        <figure className="relative radius20 w100">
          <Image
            src={imageSrc}
            alt={title || "about image"}
            width={800}
            height={500}
            className="radius20 w100 object-cover"
          />
        </figure>
      </div>

      <h1>
        <strong
          className="darkTxt"
          dangerouslySetInnerHTML={{ __html: title || "" }}
        />
        <label
          className="blueTxt"
          dangerouslySetInnerHTML={{ __html: title || "" }}
        />
      </h1>

      {content && (
        <div dangerouslySetInnerHTML={{ __html: content }} />
      )}
    </section>
  );
}
