
import Image from "next/image";
import type { CeoSection } from "@/src/types/about";

type CeoMessageProps = {
  ceoSection: CeoSection;
};

export default function CeoMessage({ ceoSection }: CeoMessageProps) {
  return (
    <section className="ceosMessage">
      <div className="mainSmall flex flexSpace alignStart">
        {/* توضیحات */}
        <div className="ceosMessage_desc">
          <div className="publicTitle">
            <div className="topTitle">
  <strong dangerouslySetInnerHTML={{ __html: ceoSection.title }} />
</div>
          </div>
          <div className="desc">
            <p>{ceoSection.description}</p>
          </div>
        </div>

        {/* Image */}
        <div className="ceosMessage_img relative">
          <figure className="overflow w100 h100 radius20">
            <Image
              src={ceoSection.picture}
              alt={ceoSection.title}
              width={500}
              height={400}
              className="w100 h100 objectfitCover"
            />
          </figure>
        </div>
      </div>
    </section>
  );
}