import InnovationsSlider from "./InnovationsSlider";
import type { InnovationSection } from "@/src/types/about";

type Props = {
  innovationSection: InnovationSection;
};
export default function HospitalInnovations({ innovationSection }: Props) {
  return (
    <section className="HospitalInnovations relative">
      <div className="mainSmall">
        <div className="publicTitle">
          <div className="topTitle flex flexDirColumn alignCenter">
            <strong dangerouslySetInnerHTML={{ __html: innovationSection.title }} />
            <p>{innovationSection.description}</p>
          </div>
        </div>
      </div>

      <InnovationsSlider items={innovationSection.items} />
    </section>
  );
}
