"use client";

import { useRef } from "react";
import Image from "next/image";
import { Swiper, SwiperSlide } from "swiper/react";
import { EffectCoverflow, Navigation, Autoplay } from "swiper/modules";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faChevronRight, faAngleLeft } from "@fortawesome/free-solid-svg-icons";
import type { InnovationSection } from "@/src/types/about";


import "swiper/css";
import "swiper/css/effect-coverflow";
import "swiper/css/navigation";

export default function InnovationsSlider({
  items,
}: {
  items: InnovationSection["items"];
}) {
  const prevRef = useRef<HTMLDivElement | null>(null);
  const nextRef = useRef<HTMLDivElement | null>(null);

  return (
    <div className="mainSmall">
      <Swiper
        modules={[EffectCoverflow, Navigation, Autoplay]}
        effect="coverflow"
        centeredSlides
        grabCursor
        loop={false}
        spaceBetween={72}
        speed={700}
        coverflowEffect={{
          rotate: -10,
          stretch: 0,
          depth: 100,
          modifier: 1,
          slideShadows: false,
        }}
        autoplay={{ delay: 6000, disableOnInteraction: false }}
        breakpoints={{
          300: { slidesPerView: 1 },
          480: { slidesPerView: 2 },
          720: { slidesPerView: 3 },
          1001: { slidesPerView: 3 },
        }}
        navigation={{ prevEl: prevRef.current, nextEl: nextRef.current }}
        onSwiper={(swiper) => {
          setTimeout(() => {
            if (swiper.params.navigation && typeof swiper.params.navigation !== "boolean") {
              swiper.params.navigation.prevEl = nextRef.current ;
              swiper.params.navigation.nextEl = prevRef.current ;
            }
            swiper.navigation.init();
            swiper.navigation.update();
          }, 0);
        }}
        className="InnovationSlider"
      >
        {items?.length ? (
          items.map((item, idx) => (
            <SwiperSlide key={idx}>
              <a href="#" className="InnovationSlider_item relative overflow">
                <figure className="InnovationSlider_item_img w100 h100">
                  <Image
                    src={item.picture}
                    alt={item.title}
                    width={500}
                    height={300}
                    className="w100 h100 objectfitCover"
                  />
                </figure>
                <figcaption className="InnovationSlider_item_txt absolute radius20">
                  <strong className="whiteTxt">{item.title}</strong>
                  <div className="desc">
                    <p>{item.description}</p>
                  </div>
                  
                </figcaption>
              </a>
            </SwiperSlide>
          ))
        ) : (
          <p className="text-center py-4">داده‌ای برای نمایش وجود ندارد</p>
        )}
      </Swiper>

      {/* navigation */}
      <div ref={nextRef} className="InnovationSlider_nextBtn publicBtn absolute flex flexCenter alignCenter">
        <FontAwesomeIcon icon={faChevronRight} />
      </div>

      <div ref={prevRef} className="InnovationSlider_prevBtn publicBtn absolute flex flexCenter alignCenter">
        <FontAwesomeIcon icon={faAngleLeft} />
      </div>
    </div>
  );
}
