import { getHistoryPage } from "@/src/lib/historyApi";
import CmsPageDetail from "@/app/components/cms/CmsPageDetail";

// ------------------ SEO ------------------
export async function generateMetadata() {
  const data = await getHistoryPage();
  const p = data.pageInfo;

  return {
    title: p.pageTitle || p.title,
    description: p.pageDescription || "",
    robots: p.pageRobotsStatus,
    openGraph: {
      title: p.ogTitle || p.pageTitle,
      description: p.ogDescription || "",
      images: [{ url: p.ogImage }],
    },
    alternates: {
      canonical: p.canonical,
    },
  };
}

// ------------------ PAGE ------------------
export default async function HistoryPage() {
  const data = await getHistoryPage();
  const p = data.pageInfo;

  return (
    <CmsPageDetail
      title={p.title}
      image={p.picture}
      content={p.content}
    />
  );
}
