import Image from "next/image";
import TitlePage from "@/app/components/common/TitlePage"; 

type MissionPageProps = {
  data: {
    title: string;
    image: string;
    html: string;
  };
};

export default function MissionPage({ data }: MissionPageProps) {
  return (
    <div className="resalatPage">
      <div className="mainSmall">

        <TitlePage title={data.title} />

        {data.image && (
          <section className="resalatPage_img relative">
            <figure className="relative">
              <Image
                src={data.image}
                alt={data.title}
                width={1200}
                height={500}
                className="w100 h100 objectfitCover"
                priority
              />
            </figure>
          </section>
        )}

        <section className="resalatPage_desc">
          <div className="desc" dangerouslySetInnerHTML={{ __html: data.html }} />
        </section>

      </div>
    </div>
  );
}
