import { notFound } from "next/navigation";
import { getMissionPage } from "@/src/lib/MissionApi";
import MissionPage from "./components/MissionPage";

// ------------------ SEO ------------------
export async function generateMetadata() {
  const p = await getMissionPage();

  if (!p) return {};

  return {
    title: p.pageTitle || p.title,
    description: p.pageDescription || "",
    robots: p.pageRobotsStatus,
    openGraph: {
      title: p.ogTitle || p.title,
      description: p.ogDescription || "",
      images: [{ url: p.ogImage }],
    },
    alternates: {
      canonical: p.canonical,
    },
  };
}

// ------------------ PAGE ------------------
export default async function Page() {
  const p = await getMissionPage();

  if (!p) return notFound();

  return (
    <MissionPage
      data={{
        title: p.title,
        image: p.picture || "",
        html: p.content || "",
      }}
    />
  );
}
