import { getAboutPage } from "@/src/lib/aboutApi";
import type { Metadata } from "next";
import AboutIntro from "./components/AboutIntro";
import AboutHistory from "./components/AboutHistory";
import CeoMassage from "./components/CeoMassage";
import HospitalInnovations from "./components/HospitalInnovations";

export const dynamic = "force-dynamic";
export const revalidate = 0;

export async function generateMetadata(): Promise<Metadata> {
  const data = await getAboutPage();

  if (!data || !data.pageInfo) {
    return {
      title: "درباره ما",
      description: "صفحه معرفی و تاریخچه بیمارستان رضوی",
    };
  }

  return {
    title: data.pageInfo.title || "درباره ما",
    description:
      data.pageInfo.pageDescription || "صفحه معرفی و تاریخچه بیمارستان رضوی",
    openGraph: {
      title: data.pageInfo.ogTitle || data.pageInfo.title,
      description:
        data.pageInfo.ogDescription || data.pageInfo.pageDescription,
      images: [
        {
          url: data.pageInfo.ogImage || "",
          width: 1200,
          height: 630,
          alt: data.pageInfo.title || "درباره ما",
        },
      ],
    },
    robots: data.pageInfo.pageRobotsStatus || "index, follow",
    alternates: {
      canonical:
        data.pageInfo.canonical ||
        "http://test2.iranrugco.com/about-us",
    },
  };
}

export default async function AboutPage() {
  const data = await getAboutPage();


  if (!data) {
    return (
      <div className="aboutPage text-center py-10">
        <p className="text-red-500">خطا در دریافت اطلاعات صفحه درباره ما</p>
      </div>
    );
  }

  const { pageInfo, historySection, ceoSection, innovationSection } = data;

  return (
    <div className="aboutPage">
      {pageInfo && <AboutIntro pageInfo={pageInfo} />}
      {historySection && <AboutHistory historySection={historySection} />}
      {ceoSection && <CeoMassage ceoSection={ceoSection} />}
      {innovationSection && (
        <HospitalInnovations innovationSection={innovationSection} />
      )}
    </div>
  );
}
