import Image from "next/image";
import TitlePage from "@/app/components/common/TitlePage";
import type { VisionPageData } from "@/src/types/vision";

type Props = {
  data: VisionPageData;
};

export default function VisionPage({ data }: Props) {
  return (
    <div className="visionPage">
      <div className="mainSmall">

        <TitlePage title={data.title} />

        {data.image && (
          <section className="visionPage_img relative">
            <figure className="relative">
              <Image
                src={data.image}
                alt={data.title}
                width={1200}
                height={500}
                className="w100 h100 objectfitCover"
                priority
              />
            </figure>
          </section>
        )}

        <section className="visionPage_desc">
          <div
            className="desc"
            dangerouslySetInnerHTML={{ __html: data.html }}
          />
        </section>

      </div>
    </div>
  );
}
