import { notFound } from "next/navigation";
import { getVisionPage } from "@/src/lib/visionApi";
import VisionPage from "./components/VisionPage";

// ------------------ SEO ------------------
export async function generateMetadata() {
  const p = await getVisionPage();
  if (!p) return {};

  return {
    title: p.pageTitle || p.title,
    description: p.pageDescription || "",
    robots: p.pageRobotsStatus,
    openGraph: {
      title: p.ogTitle || p.title,
      description: p.ogDescription || "",
      images: [{ url: p.ogImage }],
    },
    alternates: {
      canonical: p.canonical,
    },
  };
}

// ------------------ PAGE ------------------
export default async function Page() {
  const p = await getVisionPage();
  if (!p) return notFound();

  return (
    <VisionPage
      data={{
        title: p.title,
        image: p.picture || "",
        html: p.content || "",
      }}
    />
  );
}
