"use client";

import Image from "next/image";
import type { CertificateItem } from "@/src/types/certificate";

type Props = {
  certificate: CertificateItem;
  onClick: () => void;
};

export default function CertificateItemComponent({ certificate, onClick }: Props) {
  return (
    <li>
      <div className="certificateList_item relative cursorPointer" onClick={onClick}>
        <figure className="certificateList_item_img relative overflow hoverImg">
          <Image
            src={certificate.picture}
            alt={certificate.title}
            width={300}
            height={200}
            className="w100 h100 objectfitCover radius8"
          />
        </figure>
        <figcaption className="certificateList_item_title absolute z-index whiteTxt w100">
          <h2>{certificate.title}</h2>
        </figcaption>
      </div>
    </li>
  );
}
