"use client";

import { useState } from "react";
import type { CertificateItem } from "@/src/types/certificate";
import CertificateItemComponent from "./CertificateItem";
import TitlePage from "@/app/components/common/TitlePage";
import Popup from "@/app/components/common/Popup";
import Image from "next/image";

type Props = {
  items: CertificateItem[];
  title: string;
};

export default function CertificatePage({ items, title }: Props) {
  const [selected, setSelected] = useState<CertificateItem | null>(null);

  return (
    <div className="certificatePage scientificEventsPage">
      <div className="mainSmall">
        <TitlePage title={title} />

        <section className="certificatePage_list">
          <div className="certificateList">
            <ul>
              {items.map((cert) => (
                <CertificateItemComponent
                  key={cert.id}
                  certificate={cert}
                  onClick={() => setSelected(cert)}
                />
              ))}
            </ul>
          </div>
        </section>
      </div>

      {/* Popup */}
      <Popup
        isOpen={!!selected}
        onClose={() => setSelected(null)}
        popupClass="popupCertificate"
      >
        {selected && (
          <section className="popupCertificate_content">
            <div className="popupCertificate_content_item flex flexDirColumn flexCenter alignCenter">
              <figure className="popupCertificate_content_item_img radius8 overflow">
                <Image
                  src={selected.picture}
                  alt={selected.title}
                  width={800}
                  height={600}
                />
              </figure>

              <figcaption className="popupCertificate_content_item_title fontBold txtCenter">
                <h2>{selected.title}</h2>
              </figcaption>
            </div>
          </section>
        )}
      </Popup>
    </div>
  );
}
