import CertificatePage from "@/app/(sections)/certificates/components/CertificatePage";
import { getCertificatesPage } from "@/src/lib/certificatesApi";

export async function generateMetadata() {
  const data = await getCertificatesPage();

  return {
    title: data.seo.pageTitle,
    description: data.seo.pageDescription,
    openGraph: {
      title: data.seo.ogTitle,
      description: data.seo.ogDescription,
      images: [{ url: data.seo.ogImage }],
    },
    alternates: {
      canonical: data.seo.canonical,
    },
    robots: data.seo.robots,
  };
}

export default async function Page() {
  const data = await getCertificatesPage();

  return <CertificatePage items={data.certificates} title={data.title} />;
}
