import { getContactPage } from "@/src/lib/contactApi";
import ContactPage from "./components/ContactPage";
import type { ContactPageData } from "@/src/types/contact";
import { notFound } from "next/navigation";

export const dynamic = "force-dynamic";

export async function generateMetadata() {
  let data: ContactPageData | null = null;

  try {
    data = await getContactPage();
  } catch (err) {
    console.error("Error fetching contact page metadata:", err);
    return notFound();
  }

  if (!data) return notFound();

  const p = data as any;
  return {
    title: "تماس با ما | بیمارستان رضوی",
    description: "اطلاعات تماس، شماره‌ها و مسیر دسترسی بیمارستان رضوی",
    alternates: { canonical: "/contact" },
    openGraph: {
      title: "تماس با ما | بیمارستان رضوی",
      description: "اطلاعات تماس، شماره‌ها و مسیر دسترسی بیمارستان رضوی",
    },
    robots: "index, follow",
  };
}

export default async function Page() {
  let data: ContactPageData | null = null;

  try {
    data = await getContactPage();
  } catch (err) {
    console.error("Error fetching contact page:", err);
    return notFound();
  }

  if (!data) return notFound();

  return <ContactPage data={data} />;
}
