export default function DepartmentsAccessToServices({
  title,
  subtitle,
  description,
  items,
  gallery,
}: {
  title: string;
  subtitle: string;
  description: string;
  items: { label: string; value: string }[];
  gallery: { main: string; medium?: string; small?: string };
}) {
  return (
    <section className="HospitalDepartments_AccessToServices">
      <div className="publicTitle">
        <div className="topTitle flex flexDirColumn alignCenter">
          <strong>
            <span>{title}</span>
            <label>{subtitle}</label>
          </strong>
          <p>{description}</p>
        </div>
      </div>

      <div className="AccessToServicesBox flex flexSpace alignCenter">
        <div className="AccessToServices_list simple-list">
          <ul>
            {items.map((item, i) => (
              <li key={i} className="flex flexStart alignCenter">
                <span className="darkTxt">{item.label}</span>
                <p>{item.value}</p>
              </li>
            ))}
          </ul>
        </div>

        <div className="AccessToServices_gallery relative">
          <figure className="mainImg">
            <img
              src={gallery.main}
              alt={title}
              className="w100 h100 objectfitCover"
            />
          </figure>

          {gallery.medium && (
            <figure className="medImg absolute z-index">
              <img
                src={gallery.medium}
                alt=""
                className="w100 h100 objectfitCover"
              />
            </figure>
          )}

          {gallery.small && (
            <figure className="smallImg absolute z-index">
              <img
                src={gallery.small}
                alt=""
                className="w100 h100 objectfitCover"
              />
            </figure>
          )}
        </div>
      </div>
    </section>
  );
}
