export default function DepartmentConditions({
  conditions,
}: {
  conditions: string[];
}) {
  if (!conditions || conditions.length === 0) return null;

  return (
    <section className="HospitalDepartments_condition">
      <div className="titlePoint">
        <span className="darkTxt">شرایط مراجعه</span>
      </div>

      <div className="HospitalDepartments_condition_list">
        <ul>
          {conditions.map((item, index) => (
            <li key={index}>
              <div className="HospitalDepartments_condition_list_item relative radius40">
                <span>{item}</span>
              </div>
            </li>
          ))}
        </ul>
      </div>
    </section>
  );
}
