"use client"
import useOnScreen from "@/src/hooks/home/useOnScreen";
import { useRef} from "react";
interface FacilityItem {
  icon: string;
  title: string;
  desc: string;
}

export default function DepartmentsFacilities({
  title,
  subtitle,
  description,
  facilities,
}: {
  title: string;
  subtitle: string;
  description: string;
  facilities: FacilityItem[];
}) {
    const facilitiesListRef = useRef<HTMLDivElement>(null);
    const isfacilitiesListRefVisible = useOnScreen(facilitiesListRef);
  return (
    <section className="HospitalDepartments_facilities">
      <div className="publicTitle">
        <div className="topTitle flex flexDirColumn alignCenter">
          <strong>
            <span>{title}</span>
            <label>{subtitle}</label>
          </strong>
          <p>{description}</p>
        </div>
      </div>

      <div 
       ref={facilitiesListRef}
      className={`HospitalDepartments_facilities_List flex flexSpace alignCenter ${
            isfacilitiesListRefVisible ? "active" : ""
          }`}>
        <div className="HospitalDepartments_facilities_List_r relative radius50">
          <span className="darkTxt flex flexCenter alignCenter radius50">
            {title}
          </span>
        </div>

        <div className="HospitalDepartments_facilities_List_l">
          <ul className="facilities_List">
            {facilities.map((item, index) => (
              <li
                key={index}
                className="facilities_List_item flex flexStart alignCenter radius40"
              >
                <figure className="radius50 lightGreenBg flex flexCenter alignCenter">
                  <img src={item.icon} alt={item.title} />
                </figure>

                <figcaption>
                  <span className="darkTxt">{item.title}</span>
                  <p>{item.desc}</p>
                </figcaption>
              </li>
            ))}
          </ul>
        </div>
      </div>
    </section>
  );
}
