"use client";

import FaqList from "@/app/components/common/FaqList";
import { DepartmentFaqsSection } from "@/src/types/department";

export default function DepartmentsFaq({ faq }: { faq: DepartmentFaqsSection }) {
  if (!faq?.items || faq.items.length === 0) return null;

  return (
    <section className="HospitalDepartments_faqs flex flexSpace alignStart">
      <div className="faqs_r">
        <div className="publicTitle">
          <div className="topTitle">
            <strong>
              <span>سوالات متداول</span>
              <label>پرسش و پاسخ</label>
            </strong>
          </div>
        </div>
        <figure className="faqsImg">
                                    <img src="/images/faqs.png" alt=""/>
                                </figure>
      </div>

      <div className="faqs_l">
        <FaqList items={faq.items} />
      </div>
    </section>
  );
}
