"use client";

import { useEffect } from "react";
import Image from "next/image";
import { Fancybox } from "@fancyapps/ui";

import { Swiper, SwiperSlide } from "swiper/react";
import { Navigation, Pagination, EffectCoverflow, Autoplay } from "swiper/modules";

import "swiper/css";
import "swiper/css/navigation";
import "swiper/css/pagination";
import "swiper/css/effect-coverflow";
import "@fancyapps/ui/dist/fancybox/fancybox.css";

type GalleryItem = { id: number; src: string };

type Props = {
  title: string;
  subtitle: string;
  description: string;
  items: GalleryItem[];
};

export default function DepartmentGallery({
  title,
  subtitle,
  description,
  items,
}: Props) {
  useEffect(() => {
    Fancybox.bind("[data-fancybox='dep-gallery']", {});
    return () => Fancybox.destroy();
  }, []);

  return (
    <section className="HospitalDepartments_Gallery">
      <div className="publicTitle">
        <div className="topTitle flex flexDirColumn alignCenter">
          <strong>
            <span>{title}</span>
            <label>{subtitle}</label>
          </strong>
          <p>{description}</p>
        </div>
      </div>

      <div className="gallerySlider swiper-container">
        <Swiper
          modules={[Navigation, Pagination, EffectCoverflow, Autoplay]}
          slidesPerView={3}
          centeredSlides={true}
          effect="coverflow"
          loop={false}
          grabCursor={true}
          speed={700}
          spaceBetween={30}
          coverflowEffect={{
            rotate: -30,
            stretch: 0,
            depth: 100,
            modifier: 1,
            slideShadows: false,
          }}
          autoplay={{
            delay: 6000,
            disableOnInteraction: false,
          }}
          pagination={{
            el: ".galleryPagination",
            clickable: true,
          }}
          navigation={{
            nextEl: ".gallerySlider_nextBtn",
            prevEl: ".gallerySlider_prevBtn",
          }}
          className="swiper-wrapper"
          breakpoints={{
            300: { slidesPerView: 1 },
            480: { slidesPerView: 2 },
            720: { slidesPerView: 3 },
          }}
        >
          {items.map((img) => (
            <SwiperSlide key={img.id}>
              <a
                href={img.src}
                data-fancybox="dep-gallery"
                className="gallerySlider_item"
              >
                <Image
                  src={img.src}
                  alt="gallery"
                  width={600}
                  height={400}
                  className="w100 h100 objectfitCover"
                />
              </a>
            </SwiperSlide>
          ))}
        </Swiper>
      </div>

      {/* Pagination */}
      <div className="paginationSlider publicPager galleryPagination"></div>

      {/* Navigation Buttons */}
      <div className="radius12 flex flexCenter alignCenter gallerySlider_nextBtn publicBtn absolute">
        <i className="fa-light fa-chevron-right"></i>
      </div>
      <div className="radius12 flex flexCenter alignCenter gallerySlider_prevBtn publicBtn absolute">
        <i className="fa-light fa-angle-left"></i>
      </div>
    </section>
  );
}
