

interface DepartmentInfoItem {
  label: string;
  value: string;
}

interface DepartmentIntroProps {
  title: string;
  info: DepartmentInfoItem[];
  images: {
    main: string;
  };
}

export default function DepartmentIntro({ title, info, images }: DepartmentIntroProps) {
  return (
    <section className="HospitalDepartments_intro flex flexSpace alignCenter">
      <div className="HospitalDepartments_intro_r">
        <strong className="txtDark">
          معرفی کلی <label className="blueTxt">{title}</label>
        </strong>

        <div className="publicList">
          <ul>
            {info.map((item, i) => (
              <li key={i} className="flex flexStart alignStart">
                <span className="txtDark fontBold">{item.label} :</span>
                <p className="txtGray">{item.value}</p>
              </li>
            ))}
          </ul>
        </div>
      </div>

      <div className="HospitalDepartments_intro_l">
        <div className="aboutGallery">
          <div className="aboutGallery-bigImg">
              <figure>
              <img
                src={images.main}
                alt={title}
                className="w100 h100 objectfitCover"
              />
          </figure>
          </div>
        </div>
      </div>
    </section>
  );
}
