"use client";

import { useState } from "react";

type StepType = {
  title: string;
  conditionTitle: string;
  desc: string;
  image: string;
};

export default function DepartmentPreparationSteps({
  title,
  subtitle,
  description,
  steps,
}: {
  title: string;
  subtitle: string;
  description: string;
  steps: StepType[];
}) {
  const [activeTab, setActiveTab] = useState(0);

  return (
    <section className="HospitalDepartments_PreparationSteps">
      {/* ===== Title ===== */}
      <div className="publicTitle">
        <div className="topTitle flex flexDirColumn alignCenter">
          <strong>
            <span>{title}</span>
            <label>{subtitle}</label>
          </strong>
          <p className="txtCenter">{description}</p>
        </div>
      </div>

      {/* ===== Tabs ===== */}
      <div className="tabSection flex flexSpace alignStart">
        {/* ---  Tabs Menu --- */}
        <ul className="tabMenu">
          {steps.map((step, index) => (
            <li key={index}>
              <button
                className={`tabSectionItem flex flexStart alignCenter transition radius12 ${
                  activeTab === index ? "active" : ""
                }`}
                onClick={() => setActiveTab(index)}
              >
                <span className="darkTxt">{step.title}</span>

                <svg
                  width="24"
                  height="24"
                  viewBox="0 0 24 24"
                  fill="none"
                  xmlns="http://www.w3.org/2000/svg"
                >
                  <path
                    d="M9.57 5.92993L3.5 11.9999L9.57 18.0699"
                    stroke="#3D3D3D"
                    strokeWidth="1.5"
                    strokeLinecap="round"
                    strokeLinejoin="round"
                  />
                  <path
                    d="M20.4999 12H3.66992"
                    stroke="#3D3D3D"
                    strokeWidth="1.5"
                    strokeLinecap="round"
                    strokeLinejoin="round"
                  />
                </svg>
              </button>
            </li>
          ))}
        </ul>

        {/* --- Tabs Contents --- */}
        <div className="tabbox flex flexSpace alignStart active">
          <div className="tabbox_r">
            <div className="conditionTitle">
              <span className="blueTxt">{steps[activeTab].conditionTitle}</span>
            </div>

            <div className="desc">
              <strong>نحوه آمادگی :</strong>
              <p>{steps[activeTab].desc}</p>
            </div>
          </div>

          <div className="tabbox_l relative">
            <figure className="conditionImg radius20 overflow">
              <img
                src={steps[activeTab].image}
                alt={steps[activeTab].conditionTitle}
                className="w100 h100 objectFitCover"
              />
            </figure>
          </div>
        </div>
      </div>
    </section>
  );
}
