

interface DepartmentReservationProps {
  departmentName: string;
  phone: string;
  onlineLink?: string;
  resultLink?: string;
}

export default function DepartmentReservation({
  departmentName,
  phone,
  onlineLink = "#",
  resultLink = "#",
}: DepartmentReservationProps) {
  return (
    <section className="HospitalDepartments_reservation txtCenter flex flexCenter alignCenter">
      <p className="whiteTxt w100">
        جهت رزرو نوبت بخش {departmentName} با شماره‌های {phone} تماس بگیرید
      </p>

      <div className="reservationLinks flex flexCenter alignCenter w100">
        <a href={onlineLink} className="radius8 flex flexCenter alignCenter animationWhiteBox">
          نوبت دهی اینترنتی
        </a>

        <a href={resultLink} className="radius8 flex flexCenter alignCenter animationWhiteBox">
          دریافت جواب {departmentName}
        </a>
      </div>
    </section>
  );
}
