
import RoutingVideo from "../components/DepartmentsRoutingVideo";

type RoutingItem = {
  label: string;
  value: string;
};

type RoutingVideoType = {
  src: string;
  poster: string;
};

type DepartmentRoutingProps = {
  title: string;
  subtitle: string;
  description: string;
  items: RoutingItem[];
  video?: RoutingVideoType;
};

export default function DepartmentRouting({
  title,
  subtitle,
  description,
  items,
  video,
}: DepartmentRoutingProps) {
  return (
    <section className="HospitalDepartments_routing">
      <div className="publicTitle">
        <div className="topTitle flex flexDirColumn alignCenter">
          <strong>
            <span>{title}</span>
            <label>{subtitle}</label>
          </strong>
          <div className="desc">
            <p>{description}</p>
          </div>
        </div>
      </div>

      <div className="routingSec flex flexSpace alignCenter">
        <div className="routingSec_r">
          <div className="routing_list simple-list">
            <ul>
              {items.map((item, i) => (
                <li key={i} className="flex flexStart alignStart">
                  <span className="darkTxt">{item.label} :</span>
                  <p>{item.value}</p>
                </li>
              ))}
            </ul>
          </div>
        </div>

        <div className="routingSec_l">
          {video && (
            <RoutingVideo src={video.src} poster={video.poster} />
          )}
        </div>
      </div>
    </section>
  );
}
