"use client";

import { useRef, useState } from "react";

type RoutingVideoProps = {
  src: string;
  poster: string;
};

export default function RoutingVideo({ src, poster }: RoutingVideoProps) {
  const videoRef = useRef<HTMLVideoElement | null>(null);
  const [isPlaying, setIsPlaying] = useState(false);

  const togglePlay = () => {
    const video = videoRef.current;
    if (!video) return;

    if (video.paused) {
      video.play();
      setIsPlaying(true);
    } else {
      video.pause();
      setIsPlaying(false);
    }
  };

  const goFullscreen = () => {
    const video = videoRef.current;
    if (video && video.requestFullscreen) {
      video.requestFullscreen();
    }
  };

  return (
    <figure className="videoBox relative w100 h100">
      <video
        ref={videoRef}
        className="w100 h100 objectfitCover cursor-pointer"
        poster={poster}
        onClick={togglePlay}
        onDoubleClick={goFullscreen}
      >
        <source src={src} type="video/mp4" />
      </video>

      {!isPlaying && (
        <div
          className="markIcon radius50 playBtn flex flexCenter alignCenter absolute z-index cursor-pointer"
          onClick={togglePlay}
        >
          <svg
            xmlns="http://www.w3.org/2000/svg"
            width="48"
            height="48"
            viewBox="0 0 48 48"
            fill="none"
          >
            <path
              d="M15.3174 12.3457C17.0021 11.3731 19.4131 11.4571 22.1904 13.0537V13.0527L24.749 14.5322V14.5332C25.2144 14.8036 25.5 15.2987 25.5 15.8408V32.1602C25.5 32.6346 25.2815 33.0732 24.915 33.3564L24.749 33.4678L22.1895 34.9473C19.4126 36.5434 17.0019 36.6277 15.3174 35.6553C13.633 34.6829 12.5001 32.5535 12.5 29.3408V18.6602C12.5 15.4473 13.633 13.3181 15.3174 12.3457Z"
              fill="white"
              stroke="white"
            />
            <path
              d="M28 17.5801V30.4401C28 31.2201 28.84 31.7001 29.5 31.3001L31.7 30.0201C37.44 26.7201 37.44 21.2801 31.7 17.9801L29.5 16.7001C28.84 16.3201 28 16.8001 28 17.5801Z"
              fill="white"
            />
          </svg>
        </div>
      )}
    </figure>
  );
}
