export default function DepartmentsRules({
  title,
  subtitle,
  description,
  image,
  items,
}: {
  title: string;
  subtitle: string;
  description: string;
  image: string;
  items: { label: string; value: string }[];
}) {
  return (
    <section className="HospitalDepartments_Rules">
      <div className="publicTitle">
        <div className="topTitle flex flexDirColumn alignCenter">
          <strong>
            <span>{title}</span>
            <label>{subtitle}</label>
          </strong>
          <p>{description}</p>
        </div>
      </div>

      <div className="rules flex flexSpace alignCenter">
        <div className="rules_list simple-list">
          <ul>
            {items.map((item, i) => (
              <li key={i} className="flex flexStart alignStart">
                <span className="darkTxt">{item.label}</span>
                <p>{item.value}</p>
              </li>
            ))}
          </ul>
        </div>

        <div className="rulesImg">
  {image && (
    <figure>
      <img src={image} alt={title} />
    </figure>
  )}
</div>

      </div>
    </section>
  );
}
