export default function DepartmentSpecialServices({
  services,
}: {
  services: { title: string; desc: string; link?: string }[];
}) {
  if (!services || services.length === 0) return null;

  return (
    <section className="HospitalDepartments_specialServices">
      <div className="titlePoint">
        <span className="darkTxt">سرویس های ویژه یا منحصر به فرد</span>
      </div>

      <div className="specialServices_list">
        <ul>
          {services.map((srv, index) => (
            <li key={index}>
              <a
                href={srv.link || "#"}
                className="specialServices_list_item radius12"
              >
                <div className="darkTxt">
                  <strong>{srv.title}</strong>
                </div>

                <div className="desc">
                  <p>{srv.desc}</p>
                </div>
              </a>
            </li>
          ))}
        </ul>
      </div>
    </section>
  );
}
