import Image from "next/image";

type ServiceItem = {
  title: string;
  image: string;
  link?: string;
};

type DepartmentServicesProps = {
  title: string;
  subtitle: string;
  description: string;
  aboutText: string;
  patientGroups: string[];
  image: string;
  services: ServiceItem[];
};

export default function DepartmentsServicesFull({
  title,
  subtitle,
  description,
  aboutText,
  patientGroups,
  image,
  services,
}: DepartmentServicesProps) {
  const safeHTML =
    aboutText && aboutText.trim() !== ""
      ? aboutText.replace(/\n/g, "<br>")
      : "<p></p>";

  return (
    <section className="HospitalDepartments_services">
      {/* --- TOP --- */}
      <div className="HospitalDepartments_services_top flex flexSpace alignStart">
        {/*Right Text*/}
        <div className="HospitalDepartments_services_top_r">
          <div className="publicTitle">
            <div className="topTitle">
              <strong>
                <span>{title}</span>
                <label>{subtitle}</label>
              </strong>
            </div>
          </div>

          <div className="publicList">
            <ul>
              {/* Description */}
              <li>
                <span className="darkTxt">شرح خدمات کلی:</span>
                <div className="desc">
                  <div dangerouslySetInnerHTML={{ __html: safeHTML }} />
                </div>
              </li>

              {/* Target patient group */}
              {patientGroups.length > 0 && (
                <li>
                  <div className="flex flexSpace">
                    <span className="darkTxt">گروه بیماران هدف :</span>

                    <ul className="patientsGroupList flex flexStart alignCenter">
                      {patientGroups.map((item, i) => (
                        <li
                          key={i}
                          className="txtGray flex flexStart alignCenter"
                        >
                          <div className="markList flex flexCenter alignCenter">
                            <svg
                              xmlns="http://www.w3.org/2000/svg"
                              width="15"
                              height="14"
                              viewBox="0 0 15 14"
                              fill="none"
                            >
                              <path
                                d="M12.4842 3.79163L5.84817 10.2083L2.83179 7.29163"
                                stroke="white"
                                strokeWidth="1.5"
                                strokeLinecap="round"
                                strokeLinejoin="round"
                              />
                            </svg>
                          </div>
                          <span>{item}</span>
                        </li>
                      ))}
                    </ul>
                  </div>
                </li>
              )}
            </ul>
          </div>
        </div>

        {/* Left image*/}
        {image && (
          <div className="HospitalDepartments_services_top_l">
            <figure className="servicesImg relative">
              <Image
                src={image}
                alt="services"
                width={500}
                height={500}
                className="w100 h100 objectfitCover"
              />
            </figure>
          </div>
        )}
      </div>

      {/* --- BOTTOM --- */}
      {services.length > 0 && (
        <div className="HospitalDepartments_services_bottom">
          <div className="titlePoint">
            <span className="darkTxt">شرح خدمات کلی</span>
          </div>

          <div className="servicesList">
            <ul>
              {services.map((item, i) => (
                <li key={i}>
                  <a
                    href={item.link || "#"}
                    className="servicesListItem relative"
                  >
                    <figure className="servicesList_item_img radius16 overflow">
                      <Image
                        src={item.image}
                        alt={item.title}
                        width={400}
                        height={300}
                        className="w100 h100 objectfitCover"
                      />
                    </figure>

                    <figcaption className="servicesList_item_title flex flexCenter alignCenter absolute">
                      <h2>{item.title}</h2>
                    </figcaption>
                  </a>
                </li>
              ))}
            </ul>
          </div>
        </div>
      )}
    </section>
  );
}
