"use client";

import { Swiper, SwiperSlide } from "swiper/react";
import { Navigation, Autoplay } from "swiper/modules";
import "swiper/css";
import "swiper/css/navigation";

export default function DepartmentsUsers({
  title,
  subtitle,
  description,
  items,
}: {
  title: string;
  subtitle: string;
  description: string;
  items: { name: string; date: string; text: string }[];
}) {
  return (
    <section className="HospitalDepartments_Users">
      <div className="publicTitle">
        <div className="topTitle flex flexDirColumn alignCenter">
          <strong>
            <span>{title}</span>
            <label>{subtitle}</label>
          </strong>
          <p>{description}</p>
        </div>
      </div>

      <div className="usersSlider relative">
        <Swiper
          modules={[Navigation, Autoplay]}
          slidesPerView={3}
          centeredSlides
          grabCursor
          spaceBetween={56}
          speed={900}
          autoplay={{ delay: 6000, disableOnInteraction: false }}
          breakpoints={{
            300: { slidesPerView: 1, spaceBetween: 10 },
            480: { slidesPerView: 1, spaceBetween: 10 },
            720: { slidesPerView: 3, spaceBetween: 10 },
          }}

          onInit={(swiper) => {
            const container = swiper.el as HTMLElement;
            const next = container.querySelector(".usersSlider_nextBtn") as HTMLElement | null;
            const prev = container.querySelector(".usersSlider_prevBtn") as HTMLElement | null;

            if (next && prev) {
              // @ts-ignore
              swiper.params.navigation.nextEl = next;
              // @ts-ignore
              swiper.params.navigation.prevEl = prev;
              swiper.navigation.init();
              swiper.navigation.update();
            }
          }}
        >
          {items.map((item, i) => (
            <SwiperSlide key={i}>
              <div className="usersSlider_item radius16 lightGreenBg txtCenter">
                <div className="usersSlider_item_title flex flexDirColumn alignCenter">
                  <strong className="darkTxt">{item.name}</strong>
                  <time className="darkGreen txt12">{item.date}</time>
                </div>
                <div className="desc">
                  <p>{item.text}</p>
                </div>
              </div>
            </SwiperSlide>
          ))}
        </Swiper>

        {/*Navigation*/}
        <div className="radius12 flex flexCenter alignCenter usersSlider_nextBtn publicBtn absolute cursor-pointer">
          <i className="fa-light fa-chevron-right"></i>
        </div>
        <div className="radius12 flex flexCenter alignCenter usersSlider_prevBtn publicBtn absolute cursor-pointer">
          <i className="fa-light fa-angle-left"></i>
        </div>
      </div>
    </section>
  );
}
