export interface DepartmentData {
  slug: string;
  title: string;
  metaTitle: string;
  metaDescription: string;

  intro: {
    info: { label: string; value: string }[];
    images: {
      main: string;
    };
  };
   routing?: {
    items?: { label: string; value: string }[];
    video?: {
      src: string;
      poster: string;
    };
  };
}

export const departmentsData: Record<string, any> = {
  "andoscopy": {
    id: 1,
    slug: "andoscopy",
    title: "بخش آندوسکوپی",
    metaTitle: "آندوسکوپی | بیمارستان",
    metaDescription: "معرفی خدمات و رزرو بخش آندوسکوپی بیمارستان",

    intro: {
      info: [
        { label: "نام کامل بخش / واحد :", value: "آندوسکوپی" },
        { label: "نوع فعالیت :", value: "تشخیصی / درمانی" },
        { label: "موقعیت فیزیکی دقیق :", value: "ساختمان شماره 1 ، طبقه همکف" },
        { label: "تاریخ تاسیس بخش :", value: "1385" },
        { label: "فلسفه تاسیس :", value: "انجام اقدامات تشخیصی اندوسکوپی" },
        { label: "شماره تماس پاسخگویی :", value: "36004621 - 36004521 -36004620" },
        { label: "ساعت تماس :", value: "7:30 تا 19" },
        { label: "نام و سمت پاسخگو :", value: "آقای سالاری - سرپرست بخش" },
      ],

      images: {
        main: "/images/androscopi.jpg",
      }
    },

    reservation: {
      phone: "05136004620",
      onlineLink: "/online-reserve",
      resultLink: "/results",
    },

    conditions: [
  "معرفی نامه از پزشک مربوطه",
  "نوبت دهی حضوری و تلفنی",
  "ارجاعی از کلینیک و مطب پزشکان"
],
services: {
  aboutText: "...",
  patientGroups: ["سرپایی", "ارجاعی", "بستری و اورژانس"],
  image: "/images/servicesImage.jpg",
  list: [
    { title: "گاستروسکوپی", image: "/images/gastropy.png" },
    { title: "کولونوسکوپی", image: "/images/colonoscopy.jpg" },
    { title: "اندوسونوگرافی", image: "/images/andosonography.jpg" },
    { title: "ERCP", image: "/images/ERCP.png" },
  ]
},

specialServices: [
  {
    title: "روش‌های پیشرفته تشخیصی",
    desc: "لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ...",
    link: "#"
  },
  {
    title: "خدمات درمانی خاص",
    desc: "لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ...",
    link: "#"
  },
  {
    title: "تجهیزات و امکانات خاص",
    desc: "لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ...",
    link: "#"
  },
  {
    title: "مراقبت ویژه از بیماران خاص",
    desc: "لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ...",
    link: "#"
  },
],
preparationSteps: {
  title: "مراحل آماده‌سازی",
  subtitle: "قبل از آندوسکوپی",
  description:
    "رعایت این موارد برای انجام یک فرآیند ایمن و دقیق ضروری است و به پزشک کمک می‌کند تا دید بهتری از دستگاه گوارش شما داشته باشد",
  steps: [
    {
      title: "مرحله اول",
      conditionTitle: "ناشتا بودن",
      desc:
        "لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم ...",
      image: "/images/tabboxImg.png",
    },
    {
      title: "مرحله دوم",
      conditionTitle: "قطع داروهای خاص",
      desc: "متن مرحله دوم ...",
      image: "/images/tabboxImg2.png",
    },
    {
      title: "مرحله سوم",
      conditionTitle: "هماهنگی قبل از انجام",
      desc: "متن مرحله سوم ...",
      image: "/images/tabboxImg3.png",
    },
    {
      title: "مرحله چهارم",
      conditionTitle: "استراحت بعد از انجام",
      desc: "متن مرحله چهارم ...",
      image: "/images/tabboxImg4.png",
    },
  ],
},

facilities: {
  title: "امکانات و تجهیزات",
  subtitle: "پیشرفته بخش",
  description:
    "امکانات و تجهیزات پیشرفته بخش با بهره‌گیری از دستگاه‌های مدرن پزشکی...",
  items: [
    {
      icon: "/images/healthcare.png",
      title: "تجهیزات کلیدی",
      desc: "ست کامل پروسسور و منبع نور...",
    },
    {
      icon: "/images/emkanat-refahi.png",
      title: "امکانات رفاهی",
      desc: "تلوزیون و تهویه اختصاصی",
    },
    {
      icon: "/images/facilities-3.png",
      title: "مزیت رقابتی",
      desc: "تنها مرکز تخصصی شرق کشور",
    },
  ],
},
accessToServices: {
  title: "دسترسی به",
  subtitle: "خدمات و زمانبندی",
  description:
    "ساعات کاری، نحوه نوبت‌گیری و دسترسی به خدمات تشخیصی و درمانی بخش به شرح زیر می‌باشد",

  items: [
    {
      label: "ساعت کاری بخش :",
      value: "از ساعت 7 صبح لغایت 19:30",
    },
    {
      label: "ساعت ملاقات بیماران :",
      value: "لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم",
    },
    {
      label: "نحوه دریافت خدمات حضوری ، تلفنی ، آنلاین :",
      value: "تلفنی و حضوری",
    },
    {
      label: "آدرس داخلی جهت تماس از داخل بیمارستان:",
      value: "طبقه همکف ، فاز یک ، جنب پذیرش ، 36004620",
    },
  ],

  gallery: {
    main: "/images/accessToServicesBigImg.png",
    // اگر بعداً خواستی فعال کنی
    // medium: "/images/accessToServicesMedImg.png",
    // small: "/images/accessToServicesSmallImg.png",
  },
},

rules: {
  title: "قوانین و مقررات",
  subtitle: "بخش آندوسکوپی",
  description:
    "رعایت این مقررات جهت حفظ ایمنی بیماران، همراهان و پرسنل و تضمین کیفیت خدمات الزامی می‌باشد",
  image: "/images/rulesImg.png",
  items: [
    { label: "تعداد همراه مجاز :", value: "-----" },
    { label: "امکانات اختصاصی برای همراه :", value: "-----" },
    { label: "قوانین حضور و خروج برای همراه :", value: "-----" },
    { label: "ساعت خاموشی :", value: "-----" },
    { label: "نحوه اعلام عدم حضور برای حذف سیستمی :", value: "-----" },
    { label: "اطمینان از حفظ حریم خصوصی دیگر بیماران :", value: "-----" },
    { label: "سیاست حفظ محرمانگی بخش :", value: "-----" },
  ],
},
usersExperience: {
  title: "تجربیات بیماران ما در بخش",
  subtitle: "آندوسکوپی بیمارستان رضوی",
  description:
    "نظرات بیماران ما، نشان دهنده تعهد ما به ارائه بهترین خدمات پزشکی است",

  items: [
    {
      name: "حمید اعتمادی",
      date: "۱۸ آبان ۱۴۰۴",
      text: "لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ...",
    },
    {
      name: "علی محمدی",
      date: "۲۰ مهر ۱۴۰۴",
      text: "بسیار ممنون از برخورد خوب پرسنل و کیفیت خدمات...",
    },
    {
      name: "حمید اعتمادی",
      date: "۱۸ آبان ۱۴۰۴",
      text: "لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ...",
    },
    {
      name: "علی محمدی",
      date: "۲۰ مهر ۱۴۰۴",
      text: "بسیار ممنون از برخورد خوب پرسنل و کیفیت خدمات...",
    },
  ],
},
gallery: {
  title: "گالری تصاویر و فیلم‌ها",
  subtitle: "بخش آندوسکوپی",
  description: "در اینجا گوشه‌ای از فضای پیشرفته بخش را مشاهده می‌کنید",
  items: [
    { id: 1, src: "/images/galleryimg-1.jpeg" },
    { id: 2, src: "/images/galleryimg-2.jpeg" },
    { id: 3, src: "/images/galleryimg-3.jpeg" },
    { id: 4, src: "/images/galleryimg-4.jpeg" },
  ],
},

faq: {
  title: "سوالات",
  subtitle: "متداول شما",
  description: "پاسخ پرسش‌هایی که بیشتر برای شما پیش می‌آید",
  items: [
    {
      id: 1,
      question: "آیا قبل از آندوسکوپی باید ناشتا باشم؟",
      answer: "بله، ۶ تا ۸ ساعت باید ناشتا باشید."
    },
    {
      id: 2,
      question: "آیا بعد از آندوسکوپی می‌توانم رانندگی کنم؟",
      answer: "خیر، به دلیل داروی بی‌هوشی سبک توصیه نمی‌شود."
    }
  ]
},


routing: {
  items: [
    { label: "نمازخانه نزدیک", value: "مسجد بیمارستان" },
    { label: "نزدیک‌ترین سرویس بهداشتی", value: "روبروی پذیرش، فاز 1" },
    { label: "محل شارژ موبایل", value: "راهرو داخل سالن" },
    { label: "کافه‌تریا نزدیک", value: "جنب دفتر پرستاری" },
    { label: "خودپرداز / باجه بانک", value: "ورودی پذیرش" },
    { label: "پارکینگ / تاکسی", value: "درب اورژانس / ورودی پذیرش" },
  ],
  video: {
    src: "/video/andoscopy.mp4",
    poster: "/images/routingPosterVideo.png",
  }
}

  },

  // ✅ دپارتمان‌های دیگر…
};

