import { getDoctorsList } from "@/src/lib/doctorsApi";
import DoctorsListPage from "../components/DoctorsPageList";
import type { Metadata } from "next";

export async function generateMetadata(): Promise<Metadata> {
  const data = await getDoctorsList(1);

  if (!data) {
    return {
      title: "پزشکان بیمارستان رضوی",
      description: "لیست پزشکان بیمارستان فوق تخصصی رضوی",
    };
  }

  const p = data.pageInfo;

  return {
    title: p.pageTitle || p.title || "پزشکان بیمارستان رضوی",
    description: p.pageDescription || "",
    openGraph: {
      title: p.ogTitle || p.title,
      description: p.ogDescription || "",
      images: p.ogImage ? [{ url: p.ogImage }] : [],
    },
    alternates: {
      canonical: p.canonical || "/doctors",
    },
    robots: p.pageRobotsStatus || undefined,
  };
}

export default async function Page({ searchParams }: any) {
  const params = await searchParams;

  const page = Number(params?.page ?? 1);
  const name = params?.name ?? "";
  const specialty = params?.specialty ?? "";
  const departmentId = params?.departmentId ?? "";

  const data = await getDoctorsList(page, name, specialty, departmentId);

  return (
    <DoctorsListPage
      title={data.pageInfo.title}
      doctors={data.items}
      pagination={data.pagination}
    />
  );
}
