import Image from "next/image";
import Link from "next/link";
import type { DoctorCard } from "../types/doctors";

interface DoctorCardFullProps {
  doctor: DoctorCard;
}

export default function DoctorCardFull({ doctor }: DoctorCardFullProps) {
  return (
    <div className="doctorCardFull radius20 shadow overflow">
      <div className="doctorCardFull_img">
        <Image
          src={doctor.image}
          alt={doctor.name}
          width={300}
          height={300}
          className="w100 objectfitCover"
        />
      </div>
      <div className="doctorCardFull_body txtCenter">
        <h3 className="darkTxt fontBold">{doctor.name}</h3>
        <p>{doctor.specialty}</p>
        <Link
          href={`/doctors/${doctor.slug}`}
          className="radius40 greenBg whiteTxt flex flexCenter alignCenter w100 h100 animationGreenBox"
        >
          مشاهده پروفایل
        </Link>
      </div>
    </div>
  );
}
