import Image from "next/image";
import Link from "next/link";
import type { DoctorCard } from "../types/doctors";

interface DoctorCardSmallProps {
  doctor: DoctorCard;
}

export default function DoctorCardSmall({ doctor }: DoctorCardSmallProps) {
  return (
    <div className="doctorCardSmall radius16 overflow">
      <Link href={`/doctors/${doctor.slug}`} className="flex flexColumn alignCenter">
        <Image
          src={doctor.image}
          alt={doctor.name}
          width={150}
          height={150}
          className="radius50 objectfitCover"
        />
        <h3 className="fontBold">{doctor.name}</h3>
        <span>{doctor.specialty}</span>
      </Link>
    </div>
  );
}
