import Image from "next/image";
import Link from "next/link";
import type { DoctorCard } from "@/app/(sections)/doctors/types/doctors";

interface DoctorItemProps {
  doctor: DoctorCard;
}

export default function DoctorItem({ doctor }: DoctorItemProps) {
  return (
    <li>
      <div className="drsList_item radius20 relative">
        <div className="drsList_item_img relative">
          <Link href={`/doctors/${doctor.slug}`} className="radius50 overflow w100 h100 relative">
            <Image
              src={doctor.image}
              alt={doctor.name}
              width={200}
              height={200}
              className="w100 h100 objectfitCover"
            />
          </Link>
        </div>

        <div className="drsList_item_desc txtCenter">
          <Link href={`/doctors/${doctor.slug}`} className="darkTxt fontBold">
            {doctor.name}
          </Link>
          {doctor.specialty && (
            <span>{doctor.specialty}</span>
          )}
         
        </div>

        <div className="allview w100">
          <Link
            href={`/doctors/${doctor.slug}`}
            className="radius40 greenBg whiteTxt flex flexCenter alignCenter w100 h100 animationGreenBox"
          >
            مشاهده
          </Link>
        </div>
      </div>
    </li>
  );
}
