"use client";
import { useRouter } from "next/navigation";
import DoctorItem from "../components/DoctorItem";
import TitlePage from "@/app/components/common/TitlePage";
import Pagination from "@/app/components/common/Pagination";
import type { DoctorCard , DoctorListData } from "@/app/(sections)/doctors/types/doctors";
import SearchBox from "./SearchBox";

type Props = {
  title: string;
  doctors: DoctorCard[];
  pagination: DoctorListData["pagination"];
};

export default function DoctorsListPage({ title, doctors, pagination }: Props) {
  const router = useRouter();

  const handlePageChange = (page: number) => {
    router.push(`/doctors?page=${page}`);
  };

  return (
    <div className="drListPage">
      <div className="mainSmall">

        <TitlePage title={title} />
        <SearchBox />
        <section className="drListPage_list">
          <div className="drsList">
            <ul>
              {doctors.map((doctor) => (
                <DoctorItem key={doctor.id} doctor={doctor} />
              ))}
            </ul>
          </div>
        </section>
        {pagination.totalPages > 1 && (
          <Pagination
            currentPage={pagination.pageNumber}
            totalPages={pagination.totalPages}
            onPageChange={handlePageChange}
          />
        )}

      </div>
    </div>
  );
}
