
export type DoctorListData = {
  pageInfo: {
    title: string;
    content: string;
    picture: string;
    pageTitle: string;
    pageDescription: string;
    pageRobotsStatus: string;
    ogTitle: string;
    ogDescription: string;
    ogImage: string;
    slug: string;
    canonical: string;
  };

  items: {
    id: string;
    fullName: string;
    picture: string;
    rate: number | null;
    url: string;
  }[];

  pagination: {
    totalCount: number;
    pageNumber: number;
    pageSize: number;
    totalPages: number;
    hasPreviousPage: boolean;
    hasNextPage: boolean;
  };
};


export type DoctorCard = {
  id: string;
  name: string;
  image: string;
  slug: string;
  specialty: string;
  rate: number | null;
};
export type DoctorListResponse = {
  pageInfo: DoctorListData["pageInfo"];
  items: DoctorCard[];
  pagination: DoctorListData["pagination"];
};
