"use client";
import { useState, useEffect } from "react";
import EducationListItem from "./EducationListItem";
import Pagination from "@/app/components/common/Pagination";

type Props = {
  items: any[];
};

export default function EducatikonList({ items }: Props) {
  const ITEMS_PER_PAGE = 6;

  const [currentPage, setCurrentPage] = useState(1);
  const [pagedItems, setPagedItems] = useState<any[]>([]);
  const totalPages = Math.ceil(items.length / ITEMS_PER_PAGE);

  useEffect(() => {
    const start = (currentPage - 1) * ITEMS_PER_PAGE;
    const end = start + ITEMS_PER_PAGE;

    setPagedItems(items.slice(start, end));
  }, [items, currentPage]);

  return (
    <>
      <div className="educationList">
        <ul>
          {pagedItems.map((edu) => (
            <EducationListItem key={edu.slug} item={edu} />
          ))}
        </ul>
      </div>

      {totalPages > 1 && (
        <Pagination
          currentPage={currentPage}
          totalPages={totalPages}
          onPageChange={setCurrentPage}
        />
      )}
    </>
  );
}
