"use client";

type EducationIntroProps = {
  title: string;
  description: string;
  picture: string;
};

export default function EducationIntro({ title, description, picture }: EducationIntroProps) {
  return (
    <section className="educationPage_top relative">
      
      <div className="educationPage_top_img absolute">
        <figure className="w100 h100 radius12 overflow">
          {picture ? (
            <img
              src={picture}
              alt={title}
              className="w100 h100 objectfitCover"
            />
          ) : null}
        </figure>
      </div>

      <div className="educationPage_top_desc">
        <strong>{title}</strong>
        <p>{description}</p>
      </div>

    </section>
  );
}
