"use client";
import { EducationItem } from "../types/education";
import Link from "next/link";

export default function EducationCard({ item }: { item: EducationItem }) {
  return (
    <li>
        <div className="educationList_item flex flexSpace alignStart">
          <div className="educationList_item_img overflow hoverImg">
              <Link
      href={`/education/${item.slug}`}
      className="w100 h100"
    >
        <img
          src={item.picture}
          alt={item.title}
          className="w100 h100 objectfitCover"
        />
          </Link>
          </div>
          <div className="educationList_item_desc">
              <Link href={`/education/${item.slug}`} className="educationList_item_desc_title darkTxt hoverStyle">
                  {item.title}
              </Link>
              <div className="desc">
                 <p>{item.description}</p>
              </div>
              {item.date && (
                   <div className="date flex flexStart alignCenter">
                  <div className="iconItem">
                      <svg xmlns="http://www.w3.org/2000/svg" width="14" height="16" viewBox="0 0 14 16" fill="none">
                          <path d="M1.0625 6.27148H12.9451" stroke="#888888" strokeWidth="1.125" strokeLinecap="round" strokeLinejoin="round"></path>
                          <path d="M9.96094 8.875H9.96789" stroke="#888888" strokeWidth="1.125" strokeLinecap="round" strokeLinejoin="round"></path>
                          <path d="M7 8.875H7.00695" stroke="#888888" strokeWidth="1.125" strokeLinecap="round" strokeLinejoin="round"></path>
                          <path d="M4.03906 8.875H4.04601" stroke="#888888" strokeWidth="1.125" strokeLinecap="round" strokeLinejoin="round"></path>
                          <path d="M9.96094 11.4648H9.96789" stroke="#888888" strokeWidth="1.125" strokeLinecap="round" strokeLinejoin="round"></path>
                          <path d="M7 11.4648H7.00695" stroke="#888888" strokeWidth="1.125" strokeLinecap="round" strokeLinejoin="round"></path>
                          <path d="M4.03906 11.4648H4.04601" stroke="#888888" strokeWidth="1.125" strokeLinecap="round" strokeLinejoin="round"></path>
                          <path d="M9.69531 1.33398V3.52784" stroke="#888888" strokeWidth="1.125" strokeLinecap="round" strokeLinejoin="round"></path>
                          <path d="M4.3125 1.33398V3.52784" stroke="#888888" strokeWidth="1.125" strokeLinecap="round" strokeLinejoin="round"></path>
                          <path fillRule="evenodd" clipRule="evenodd" d="M9.82551 2.38672H4.18064C2.22285 2.38672 1 3.47734 1 5.48207V11.5152C1 13.5514 2.22285 14.6673 4.18064 14.6673H9.81933C11.7833 14.6673 13 13.5703 13 11.5656V5.48207C13.0062 3.47734 11.7895 2.38672 9.82551 2.38672Z" stroke="#888888" strokeWidth="1.125" strokeLinecap="round" strokeLinejoin="round"></path>
                        </svg>
                  </div>
                  <time className="dateItem">
                      {item.date}
                  </time>
              </div>
              )}
             
              <Link href={`/education/${item.slug}`} className="viewAll flex flexSpace alignCenter greenBg whiteTxt transition animationGreenBox">
                <span>
                    مشاهده بیشتر
                </span>
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                   <path d="M9.57 5.93005L3.5 12.0001L9.57 18.0701" stroke="white" strokeWidth="1.5" strokeMiterlimit="10" strokeLinecap="round" strokeLinejoin="round"></path>
                   <path d="M20.5019 12H3.67188" stroke="white" strokeWidth="1.5" strokeMiterlimit="10" strokeLinecap="round" strokeLinejoin="round"></path>
                </svg>
              </Link>
          </div>
    </div>
    </li>
    
  
  );
}
