"use client";

import { Suspense } from "react";
import MostViewedEducationContent from "../components/MostViewedEducationContent";

type Props = {
  items: {
    title: string;
    slug: string;
    picture: string;
    publishedDate: string;
    summary: string;
  }[];
  categories: { title: string; slug: string }[];
};

export default function MostViewedEducation({ items, categories }: Props) {
  if (!items || items.length === 0) return null;

  return (
    <Suspense fallback={<div>در حال بارگذاری...</div>}>
      <MostViewedEducationContent items={items} categories={categories} />
    </Suspense>
  );
}
