"use client";

import CategorySlider from "@/app/components/common/CategorySlider";
import InnerTitle from "@/app/components/common/InnerTitle";
import EducatikonList from "./EducatikonList";
import { useSearchParams } from "next/navigation";

type Props = {
  categories: { title: string; slug: string }[];
  items: any[];
};

export default function MostViewedEducationContent({ categories, items }: Props) {
  const searchParams = useSearchParams();
  const category = searchParams.get("category") || "all";

  const filteredItems =
    category === "all"
      ? items
      : items.filter((edu) => edu.category === category);

  return (
    <section className="educationPage_mostViewEdu">
      <InnerTitle first="پربازدیدترین" second="آموزش‌ها" />

      <CategorySlider
        categories={categories.map((c) => ({
          id: c.slug,
          slug: c.slug,
          label: c.title,
        }))}
        basePath="/education/list"
        selectedCategory={category}
      />

      <EducatikonList
        items={filteredItems.map((i) => ({
          slug: i.slug,
          title: i.title,
          picture: i.picture,
          publishedDate: i.publishedDate,
          timeStudy: i.timeStudy,
        }))}
      />
    </section>
  );
}
