"use client";

import Link from "next/link";
import InnerTitle from "@/app/components/common/InnerTitle";
import CategorySlider from "@/app/components/common/CategorySlider";
type NewestEducationProps = {
  categories: { title: string; slug: string }[];
  items: {
    title: string;
    slug: string;
    picture: string;
    publishedDate: string;
    timeStudy: string;
    summary: string;
  }[];
};

export default function NewestEducation({ categories, items }: NewestEducationProps) {

  if (!items || items.length === 0) return null;

  return (
    <section className="educationPage_newestEdu">
      <InnerTitle
        first="جدیدترین"
        second="آموزش‌ها"
        allLink="/education/list"
      />
   <CategorySlider
  categories={categories.map(c => ({
    id: c.slug,
    slug: c.slug,
    label: c.title, 
  }))}
  basePath="/education/list"
  selectedCategory="all"
/>

      <div className="educationPage_newestEdu_list flex flexSpace">

        <div className="educationPage_newestEdu_list_r">

          <div className="educationPage_newestEdu_list_r_up flex flexSpace">
            {items.slice(0, 2).map((edu) => (
              <EducationCard key={edu.slug} edu={edu} />
            ))}
          </div>
          <div className="educationPage_newestEdu_list_r_down flex flexSpace">
            {items.slice(2, 4).map((edu) => (
              <EducationCard key={edu.slug} edu={edu} />
            ))}
          </div>
        </div>

        <div className="educationPage_newestEdu_list_l">
          {items[4] && <EducationCard edu={items[4]} />}
        </div>

      </div>
    </section>
  );
}

function EducationCard({ edu }: { edu: any }) {
  return (
    <Link
      className="educationList_Item radius24 overflow"
      href={`/education/${edu.slug}`}
    >
      <figure className="educationList_Item_img relative w100 h100">
        <img
          src={edu.picture}
          alt={edu.title}
          className="w100 h100 objectfitCover"
        />
      </figure>

      <figcaption className="educationList_Item_txt absolute w100 z-index">
        <div className="educationList_Item_title whiteTxt">
          <h2>{edu.title}</h2>
        </div>

        <div className="desc">
          <p>{edu.summary}</p>
        </div>

        <div className="date flex flexSpace alignCenter">
          {edu.publishedDate && (
          <div className="date_r flex flexStart alignCenter">
            <div className="IconItem flex flexCenter alignCenter">
                 <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                     <path d="M14.6673 8.00004C14.6673 11.68 11.6807 14.6667 8.00065 14.6667C4.32065 14.6667 1.33398 11.68 1.33398 8.00004C1.33398 4.32004 4.32065 1.33337 8.00065 1.33337C11.6807 1.33337 14.6673 4.32004 14.6673 8.00004Z" stroke="#05C7BB" stroke-width="0.875" stroke-linecap="round" stroke-linejoin="round"></path>
                     <path d="M10.4739 10.12L8.40724 8.88671C8.04724 8.67338 7.75391 8.16005 7.75391 7.74005V5.00671" stroke="#05C7BB" stroke-width="0.875" stroke-linecap="round" stroke-linejoin="round"></path>
                 </svg>
            </div>
            <time dateTime={edu.publishedDate}>{edu.publishedDate}</time>
          </div>
          )}
          {edu.timeStudy && (
               <div className="date_l flex flexEnd alignCenter">
              <div className="IconItem flex flexCenter alignCenter">
                 <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 12 12" fill="none">
                     <path d="M6 11.0398C5.85 11.0398 5.7 11.0048 5.575 10.9348C4.64 10.4248 2.995 9.88476 1.965 9.74976L1.82 9.72976C1.165 9.64976 0.625 9.03476 0.625 8.36976V2.32976C0.625 1.93476 0.78 1.57476 1.065 1.31476C1.35 1.05476 1.72 0.92976 2.11 0.96476C3.21 1.04976 4.87 1.59976 5.81 2.18976L5.93 2.25976C5.965 2.27976 6.04 2.27976 6.07 2.26476L6.15 2.21476C7.09 1.62476 8.75 1.06476 9.855 0.96976C9.865 0.96976 9.905 0.96976 9.915 0.96976C10.28 0.93476 10.655 1.06476 10.935 1.32476C11.22 1.58476 11.375 1.94476 11.375 2.33976V8.37476C11.375 9.04476 10.835 9.65476 10.175 9.73476L10.01 9.75476C8.98 9.88976 7.33 10.4348 6.415 10.9398C6.295 11.0098 6.15 11.0398 6 11.0398ZM1.99 1.70976C1.83 1.70976 1.685 1.76476 1.57 1.86976C1.445 1.98476 1.375 2.14976 1.375 2.32976V8.36976C1.375 8.66476 1.63 8.94976 1.915 8.98976L2.065 9.00976C3.19 9.15976 4.915 9.72476 5.915 10.2698C5.96 10.2898 6.025 10.2948 6.05 10.2848C7.05 9.72976 8.785 9.15976 9.915 9.00976L10.085 8.98976C10.37 8.95476 10.625 8.66476 10.625 8.36976V2.33476C10.625 2.14976 10.555 1.98976 10.43 1.86976C10.3 1.75476 10.135 1.69976 9.95 1.70976C9.94 1.70976 9.9 1.70976 9.89 1.70976C8.935 1.79476 7.395 2.30976 6.555 2.83476L6.475 2.88976C6.2 3.05976 5.81 3.05976 5.545 2.89476L5.425 2.82476C4.57 2.29976 3.03 1.78976 2.05 1.70976C2.03 1.70976 2.01 1.70976 1.99 1.70976Z" fill="#05C7BB"></path>
                     <path d="M6 10.62C5.795 10.62 5.625 10.45 5.625 10.245V2.745C5.625 2.54 5.795 2.37 6 2.37C6.205 2.37 6.375 2.54 6.375 2.745V10.245C6.375 10.455 6.205 10.62 6 10.62Z" fill="#05C7BB"></path>
                     <path d="M3.875 4.62H2.75C2.545 4.62 2.375 4.45 2.375 4.245C2.375 4.04 2.545 3.87 2.75 3.87H3.875C4.08 3.87 4.25 4.04 4.25 4.245C4.25 4.45 4.08 4.62 3.875 4.62Z" fill="#05C7BB"></path>
                     <path d="M4.25 6.12H2.75C2.545 6.12 2.375 5.95 2.375 5.745C2.375 5.54 2.545 5.37 2.75 5.37H4.25C4.455 5.37 4.625 5.54 4.625 5.745C4.625 5.95 4.455 6.12 4.25 6.12Z" fill="#05C7BB"></path>
                 </svg>
              </div>
            <span>{edu.timeStudy}</span>
          </div>
          )}
         
        </div>
      </figcaption>
    </Link>
  );
}
