import EducationIntro from "./components/EducationIntro";
import NewestEducation from "./components/NewestEducation";
import MostViewedEducation from "./components/MostViewedEducation";
import { getTutorialsList } from "@/src/lib/getTutorialsList";
import { notFound } from "next/navigation";
import type { Metadata } from "next";

export const dynamic = "force-dynamic";

export async function generateMetadata(): Promise<Metadata> {
  const data = await getTutorialsList();
  if (!data) return {};

  const seo = data.pageInfo;

  return {
    title: seo.pageTitle,
    description: seo.pageDescription,
    robots: seo.pageRobotsStatus ?? "index,follow",
    alternates: {
      canonical: seo.canonical,
    },
    openGraph: {
      title: seo.ogTitle,
      description: seo.ogDescription,
      images: [{ url: seo.ogImage }],
      type: "website",
      url: seo.canonical,
    },
  };
}

export default async function EducationPage() {
  const data = await getTutorialsList();
  if (!data) return notFound();

  return (
    <div className="educationPage">
      <div className="mainSmall">

        <EducationIntro
          title={data.pageInfo.title}
          description={data.pageInfo.content}
          picture={data.pageInfo.picture}
        />

        <NewestEducation
          categories={data.newestCategories}
          items={data.newest}
        />

       <MostViewedEducation
          items={data.mostViewed}
          categories={data.newestCategories}
        />

      </div>
    </div>
  );
}
