import Image from "next/image";
import type { FacilityItem } from "../types/facilities";
import { div } from "framer-motion/client";

export default function FacilityContent({ tab }: { tab: FacilityItem }) {
  return (
    <div className="frameLoading w100">
        {/* Image */}
        {tab.picture && (
          <div className="facilitiesPageFrame relative">
               <div className="facilitiesPage_img w100 radius16 overflow">
            <figure className="w100 h100">
              <Image
                src={tab.picture}
                alt={tab.title}
                width={600}
                height={400}
                className="w100 h100 objectfitCover"
              />
            </figure>
          </div>
          </div>
         
        )}

        {/* Text */}
        <div className="borderLightGray radius16 bgWhite relative">
          <div className="desc">

            {/* Title */}
            {tab.title && (
              <span className="blueTxt fontBold w100">{tab.title}</span>
            )}

            {/* HTML content*/}
            <div
              className="txtGray"
              dangerouslySetInnerHTML={{ __html: tab.content }}
            />
          </div>
        </div>
    </div>
  );
}
