"use client";

import Tabs from "@/app/components/common/Tabs";
import TitlePage from "@/app/components/common/TitlePage";
import FacilityContent from "./FacilityContent";
import type { FacilityItem, FacilitiesPageData } from "../types/facilities";

export default function FacilitiesPage({
  pageInfo,
  facilities,
}: FacilitiesPageData) {
  return (
    <div className="visitorsGuidePage facilitiesPage">
      <div className="mainSmall">
        <TitlePage title={pageInfo.title} />

        <section className="visitorsGuide_list facilitiesPage_content flex flexSpace alignStart">
          <Tabs
            tabs={facilities.map((f, index) => ({
              id: index.toString(),
              label: f.title,
              content: <FacilityContent tab={f} />,
            }))}
          />
        </section>
      </div>
    </div>
  );
}
