import { getFacilitiesPage } from "@/src/lib/facilitiesApi";
import FacilitiesPage from "./components/FacilityPage";
import type { Metadata } from "next";

export async function generateMetadata(): Promise<Metadata> {
  const data = await getFacilitiesPage();

  return {
    title: data.pageInfo.pageTitle,
    description: data.pageInfo.pageDescription,
    openGraph: {
      title: data.pageInfo.ogTitle,
      description: data.pageInfo.ogDescription,
      images: [{ url: data.pageInfo.ogImage }],
    },
    alternates: {
      canonical: data.pageInfo.canonical,
    },
    robots: data.pageInfo.pageRobotsStatus,
  };
}

export default async function Page() {
  const data = await getFacilitiesPage();

  return (
    <FacilitiesPage
      pageInfo={data.pageInfo}
      facilities={data.facilities}
    />
  );
}
